import java.awt.*;
import java.awt.event.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * Beschreibung
  * Sportfest - Test
  * Version 1.0 vom 12.2.2018
  * vom Hau 
  */

public class SportfestAnwendung extends JFrame {
  // Anfang Attribute
  private JButton btStart = new JButton();
  private String aus ="";
  private JTextArea taAusgabe = new JTextArea("");
    private JScrollPane taAusgabeScrollPane = new JScrollPane(taAusgabe);
  private JNumberField nfGruppe = new JNumberField();
  private JLabel jLabel1 = new JLabel();
  private JLabel jLabel2 = new JLabel();
  private JNumberField nfWettkampf = new JNumberField();
  private JButton btLadeWettkampfgruppe = new JButton();
  private JButton btAktualisiereZeit = new JButton();
  private JLabel jLabel3 = new JLabel();
  private JNumberField nfTeilnehmer = new JNumberField();
  private JLabel jLabel4 = new JLabel();
  private JNumberField nfZeit = new JNumberField();
  private JButton btInDatenbank = new JButton();
  // Ende Attribute
  DatabaseConnector dbcDatenbank;
  Anzeige wettkampfAnzeige = new Anzeige();
  Wettkampfverwalter verwalter;
  
  public SportfestAnwendung(String title) { 
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
    int frameWidth = 300; 
    int frameHeight = 600;
    setSize(frameWidth, frameHeight);
    setLocation(50, 50);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    btStart.setBounds(40, 24, 97, 41);
    btStart.setText("Start");
    btStart.setMargin(new Insets(2, 2, 2, 2));
    btStart.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btStart_ActionPerformed(evt);
      }
    });
    cp.add(btStart);
    taAusgabeScrollPane.setBounds(16, 72, 257, 177);
    cp.add(taAusgabeScrollPane);
    nfGruppe.setBounds(80, 288, 41, 25);
    nfGruppe.setText("5");
    cp.add(nfGruppe);
    jLabel1.setBounds(16, 288, 54, 20);
    jLabel1.setText("Gruppe");
    cp.add(jLabel1);
    jLabel2.setBounds(136, 288, 70, 20);
    jLabel2.setText("Wettkampf");
    cp.add(jLabel2);
    nfWettkampf.setBounds(224, 288, 41, 25);
    nfWettkampf.setText("2");
    cp.add(nfWettkampf);
    btLadeWettkampfgruppe.setBounds(24, 328, 169, 41);
    btLadeWettkampfgruppe.setText("lade Wettkampfgruppe");
    btLadeWettkampfgruppe.setMargin(new Insets(2, 2, 2, 2));
    btLadeWettkampfgruppe.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btLadeWettkampfgruppe_ActionPerformed(evt);
      }
    });
    cp.add(btLadeWettkampfgruppe);
    btAktualisiereZeit.setBounds(24, 432, 169, 49);
    btAktualisiereZeit.setText("aktualisiere Zeit");
    btAktualisiereZeit.setMargin(new Insets(2, 2, 2, 2));
    btAktualisiereZeit.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btAktualisiereZeit_ActionPerformed(evt);
      }
    });
    cp.add(btAktualisiereZeit);
    jLabel3.setBounds(24, 384, 67, 33);
    jLabel3.setText("Teilnehmer");
    cp.add(jLabel3);
    nfTeilnehmer.setBounds(104, 392, 41, 25);
    nfTeilnehmer.setText("5");
    cp.add(nfTeilnehmer);
    jLabel4.setBounds(168, 384, 43, 33);
    jLabel4.setText("Zeit");
    cp.add(jLabel4);
    nfZeit.setBounds(216, 392, 57, 25);
    nfZeit.setText("1000");
    cp.add(nfZeit);
    btInDatenbank.setBounds(24, 504, 169, 41);
    btInDatenbank.setText("Speichern in Datenbank");
    btInDatenbank.setMargin(new Insets(2, 2, 2, 2));
    btInDatenbank.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btInDatenbank_ActionPerformed(evt);
      }
    });
    cp.add(btInDatenbank);
    // Ende Komponenten
    
    setVisible(true);
  } // end of public SportfestAnwendung
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new SportfestAnwendung("SportfestAnwendung");
  } // end of main
  
  public void btStart_ActionPerformed(ActionEvent evt) {
    String [][] daten;
    QueryResult ergebnis;
    dbcDatenbank = new  DatabaseConnector("127.0.0.1", 3306, "Sportfest.db", "", "");
    
    aus = aus + dbcDatenbank.getErrorMessage() + "\n";
    taAusgabe.setText(aus);
    dbcDatenbank.executeStatement("SELECT * from Teilnehmer;");
    aus = aus + dbcDatenbank.getErrorMessage() + "\n";
    taAusgabe.setText(aus);
    ergebnis=  dbcDatenbank.getCurrentQueryResult();
    daten= ergebnis.getData();
    for (int i=0;i<ergebnis.getRowCount() ;i++ ) {
      for (int j =0;j<ergebnis.getColumnCount(); j++) {
        aus=aus+" - "+ daten[i][j];
      } // end of for
      aus=aus+"\n";
    } // end of for
    taAusgabe.setText(aus);
    wettkampfAnzeige.setVisible(true);
    verwalter = new Wettkampfverwalter(dbcDatenbank, wettkampfAnzeige);
  } // end of btStart_ActionPerformed
  
  public void btLadeWettkampfgruppe_ActionPerformed(ActionEvent evt) {
    verwalter.ladeWettkampfgruppe(nfWettkampf.getInt(), nfGruppe.getInt());
    
  } // end of btLadeWettkampfgruppe_ActionPerformed

  public void btAktualisiereZeit_ActionPerformed(ActionEvent evt) {
    verwalter.aktualisiereZeit(nfTeilnehmer.getInt(), nfZeit.getInt());
    
  } // end of btAktualisiereZeit_ActionPerformed

  public void btInDatenbank_ActionPerformed(ActionEvent evt) {
    verwalter.tueEtwas();
    
  } // end of btInDatenbank_ActionPerformed

  // Ende Methoden
} // end of class SportfestAnwendung
